Imports System.IO
Imports System.Runtime.Serialization.Formatters.Binary
Imports System.Runtime.Serialization.Formatters.Soap

Module Module1

    Sub Main()
        ' Construire une voiture et couter la radio.
        Console.WriteLine("La voiture James Bond est cre...")
        Dim myAuto As JamesBondCar = New JamesBondCar("Fred", 50, False, True)
        myAuto.TurnOnRadio(True)
        myAuto.GoUnderWater()

        ' Maintenant sauver cette voiture dans un flux binaire.
        Dim myStream As FileStream = File.Create("CarData.dat")
        Dim myBinaryFormat As BinaryFormatter = New BinaryFormatter()
        myBinaryFormat.Serialize(myStream, myAuto)
        myStream.Close()
        Console.WriteLine("Sauvegarde de la voiture vers cardata.dat.")

        ' Lire la voiture depuis le flux binaire.
        Console.WriteLine("Lecture d'une voiture depuis le fichier binaire.")
        myStream = File.OpenRead("CarData.dat")
        Dim carFromDisk As JamesBondCar = CType(myBinaryFormat.Deserialize(myStream), JamesBondCar)
        Console.WriteLine(carFromDisk.PetName + " est en tat de marche!")
        carFromDisk.TurnOnRadio(True)
        myStream.Close()

        ' Sauver la mme voiture dans le format SOAP.
        Console.WriteLine("Maintenant, sauvegarde de la voiture dans un fichier XML")
        myStream = File.Create("CarData.xml")
        Dim myXMLFormat As SoapFormatter = New SoapFormatter()
        myXMLFormat.Serialize(myStream, myAuto)
        myStream.Close()

        ' Lecture de la voiture depuis le fichier XML.
        Console.WriteLine("Lecture d'une voiture depuis un fichier XML.")
        myStream = File.OpenRead("CarData.xml")
        Dim carFromXML As JamesBondCar = CType(myXMLFormat.Deserialize(myStream), JamesBondCar)
        Console.WriteLine(carFromXML.PetName + " est en tat de marche!")
        carFromXML.TurnOnRadio(True)
        myStream.Close()
    End Sub

End Module
